
//~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include <gc.h>
//~~~~~~~~~~~~~~~~~~~~~~~~~~~



/******************************************************************************
*
*  Render_boxquart 
*
*******************************************************************************
*  Draws apatch in the center of the screen that is half-height & half-width
*  of the screen.
*
*******************************************************************************
*  Usage:
*     Render_boxquart( TGC* gc );
*
*  Arguments:
*     gc        - the graphics context being drawn on.
*
*  Returns:
*     bool completed - true if the image could be drawn.
*                    - false if it can't be drawn.
*
*******************************************************************************
*/
bool Render_boxquart( TGC* gc )
{
  //*** Indicate that this image allows one alternate image rendition.
  gc->Versions( 1 );

  //*** Setup the LUT
  gc->SetLut( BW );

  //*** Clear the active area of the screen
  gc->WipeActive();

  //*** Use the default foreground and background colors.
  //*** Normally these will be set to white and black respectively.
  //*** However, with Versions set to 1 the generator will automatically
  //*** invert these two when the alternate rendition is selected. That is
  //*** the foreground will set to black and the background white.
  gc->Opaque( gc->foreground, gc->background );

  //*** Render a box centered on the screen and a quarter of the size of the screen
  gc->FillRect( gc->width/2, gc->height/2, gc->width/4, gc->height/4 );

  //*** Return "true" to indicate success.
  return true;
}
